@echo off
rem Get the directory of the current batch file
set script_dir=%~dp0

rem Remove the trailing backslash from the path
set script_dir=%script_dir:~0,-1%

rem Define global variables for executable paths and service name
set "nssm_path=%script_dir%\nssm.exe"
set "tfcenter_mount_path=%script_dir%\tfcenter-daemon.exe"
set "service_name=tfcenter-daemon"

rem Check if the files exist
if not exist "%nssm_path%" (
    echo Error: nssm.exe not found in "%script_dir%".
    pause
    exit /b 1
)

rem Display menu once
echo -------------------------------------------------
echo Please choose the action to perform:
echo 1. Install service
echo 2. Remove service
echo 3. Start service
echo 4. Stop service
echo 5. Query service status
echo 6. Set service sysName
echo 7. Query service sysName
echo 8. Open nssm install GUI
echo 9. Open nssm remove GUI
echo 10. Open nssm edit GUI
echo 0. Exit
echo -------------------------------------------------

:menu
rem Prompt the user for input
set /p choice=Enter 1, 2, 3, 4, 5, 6, 7 , 8, 9, 10 or 0 and press Enter(%service_name%): 

rem Perform the chosen action
if "%choice%"=="1" (
    if not exist "%tfcenter_mount_path%" (
        echo Error: not found "%tfcenter_mount_path%".
        echo -------------------------------------------------
        goto menu
    )

    echo Installing service...
    "%nssm_path%" install %service_name% "%tfcenter_mount_path%"
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="2" (
    echo Removing service...
    "%nssm_path%" remove %service_name% confirm
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="3" (
    echo Starting service...
    "%nssm_path%" start %service_name%
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="4" (
    echo Stopping service...
    "%nssm_path%" stop %service_name%
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="5" (
    echo Querying service status...
    "%nssm_path%" status %service_name%
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="6" (
    call :set_service_sysName
	echo -------------------------------------------------
	goto menu
) else if "%choice%"=="7" (
    echo Querying service sysName...
    "%nssm_path%" get %service_name% ObjectName
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="8" (
    echo Open nssm install GUI...
    "%nssm_path%" install
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="9" (
    echo Open nssm remove GUI...
    "%nssm_path%" remove
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="10" (
    echo Open nssm edit GUI...
    call :edit_service
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="0" (
    echo Exiting...
) else (
    echo Invalid choice, please enter 1, 2, 3, 4, 5, or 0.
    echo -------------------------------------------------
    goto menu
)

if "%choice%"=="6" (
:set_service_sysName
set /p para1=Enter the first parameter (username): 
set /p para2=Enter the second parameter (password): 
echo Setting service sysName...
"%nssm_path%" set %service_name% ObjectName .\%para1% %para2%
)

if "%choice%"=="10" (
:edit_service
set /p para20=Enter the service name:  
"%nssm_path%" edit %para20%
)

pause
