chcp 65001
@echo off
rem Get the directory of the current batch file
set script_dir=%~dp0

rem Remove the trailing backslash from the path
set script_dir=%script_dir:~0,-1%

rem Define global variables for executable paths and service name
set "nssm_path=%script_dir%\nssm.exe"
set "tfcenter_mount_path=%script_dir%\tfcenter-service.exe"
set "service_name=tfcenter-service"

rem Check if the files exist
if not exist "%nssm_path%" (
    echo Error: nssm.exe not found in "%script_dir%".
    pause
    exit /b 1
)

rem Display menu once
echo -------------------------------------------------
echo 请选择以下操作执行:
echo 1. 安装tfcenter服务
echo 2. 卸载tfcenter服务
echo 3. 启动tfcenter服务
echo 4. 停止tfcenter服务
echo 5. 查询tfcenter服务
echo 6. 重置tfcenter密码
echo 7. 查看tfcenter监听端口列表
echo 0. Exit
echo -------------------------------------------------

:menu
rem Prompt the user for input
set /p choice=Enter 1, 2, 3, 4, 5, 6, 7 or 0 and press Enter(%service_name%): 

rem Perform the chosen action
if "%choice%"=="1" (
    if not exist "%tfcenter_mount_path%" (
        echo Error: not found "%tfcenter_mount_path%".
        echo -------------------------------------------------
        goto menu
    )

    echo Installing service...
    "%nssm_path%" install %service_name% "%tfcenter_mount_path%"
    "%nssm_path%" set %service_name% Start SERVICE_AUTO_START
    "%nssm_path%" set %service_name% AppRestartDelay 5000
    "%nssm_path%" set %service_name% AppExit Default Restart
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="2" (
    echo Removing service...
    "%nssm_path%" remove %service_name% confirm
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="3" (
    echo Starting service...
    "%nssm_path%" start %service_name%
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="4" (
    echo Stopping service...
    "%nssm_path%" stop %service_name%
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="5" (
    echo Querying service status...
    "%nssm_path%" status %service_name%
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="6" (
    echo Reset password...
    "%tfcenter_mount_path%" --reset
	echo -------------------------------------------------
	goto menu
) else if "%choice%"=="7" (
    echo find listen port...
    for /f "tokens=2" %%a in ('tasklist /fi "imagename eq tfcenter-service.exe" /nh') do (
        set pid=%%a
        echo tfcenter-service.exe 的 PID: %%a
        echo === 所有活动连接 ===
        netstat -ano | findstr %%a | findstr "LISTENING"
    )
	echo -------------------------------------------------
	goto menu
) else if "%choice%"=="21" (
    echo Open nssm install GUI...
    "%nssm_path%" install
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="22" (
    echo Open nssm remove GUI...
    "%nssm_path%" remove
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="23" (
    echo Open nssm edit GUI...
    call :edit_service
    echo -------------------------------------------------
    goto menu
) else if "%choice%"=="0" (
    echo Exiting...
) else (
    echo Invalid choice, please enter 1, 2, 3, 4, 5, 6, 7 or 0.
    echo -------------------------------------------------
    goto menu
)

if "%choice%"=="9" (
:edit_service
set /p para20=Enter the service name:  
"%nssm_path%" edit %para20%
)

pause
